; BMPVIEW.ASM - Alexander Shabarshin (shaos@mail.ru)
; http://www.shaos.ru/nedopc/sprinter/
; Copyright (c) 2002-2003, Shaos
; ZMAC -o bmpview.exe bmpview.asm
; Usage: BMPVIEW file.bmp
; BMP 320x256 with 256 colors palette (82998 or 83000 bytes)

	ORG	#8100-512

	DB	"EXE"	;EXE ID
	DB	#00	;EXE VERSION
	DW	#0200	;CODE OFFSET LOW
	DW	#0000	;CODE OFFSET HIGH
	DW	#0000	;END-BEG ;PRIMARY LOADER
	DW	#0000	;
	DW	#0000	;RESERVED
	DW	#0000	;
	DW	#8100	;LOAD ADDRESS
	DW	#8100	;START ADDRESS
	DW	#C000	;STACK ADDRESS
	DS	490

start:	push	ix	; save address of arguments

	ld	c,#51
	rst	10h
	ld	c,a
	push	bc
	pop	hl
	ld	(oldmode),hl

	ld	a,81h
	ld	c,#50
	ld	b,0
	rst	10h

	pop	hl      ; address of arguments
	ld	a,(hl)	; arguments length
	push	af

bmp1:	inc	hl
	ld	a,(hl)
	cp	#20
	jp	z,bmp1
	ld	de,name_

	pop	af
	call	acopy_a_
	call	loadbmp

	ld	c,#30
	rst	10h

exit:	ld	hl,(oldmode)
	push	hl
	pop	bc
	ld	a,c
	ld	c,#50
	rst	10h
	ld	c,#41
	rst	10h
	ret

oldmode dw	0
oldwin_	db	0
handle_	db	0
name_	ds	16
pal_	ds	1280

loadbmp:
	ld	hl,name_
	ld	c,11h
	ld	a,1
	rst	10h
	jr	c,any_error_3
	ld	(handle_),a
	
	ld	c,15h
	ld	a,(handle_)
	ld	b,0
	ld	hl,0
	ld	ix,#36
	rst	10h
	jr      c,any_error_2

	ld	c,13h
	ld	a,(handle_)
	ld	de,1024
	ld	hl,pal_
	rst	10h
	jr      c,any_error_2

	ld	c,0A4h
	ld	hl,pal_
	ld	e,0
	ld	d,0
	ld	b,0FFh
	ld	a,0
	rst	8h

	in	a,(0E2h)
	ld	(oldwin_),a
	ld	a,50h
	out	(0E2h),a

	ld	a,0
loopi_:
	push	af
	ld	c,13h
	ld	a,(handle_)
	ld	de,1280
	ld	hl,pal_
	rst	10h
	pop	af
	jr      c,any_error_1

	ld	bc,160
	ld	hl,pal_
	ld	d,4
loopo_:
	push	de
        dec	a
	out	(89h),a
	ld	de,0C000h
	call	acopy_160_
	add	hl,bc
	ld	de,0C0A0h
	call	acopy_160_
	add	hl,bc
	pop	de
	dec	d
	jr	nz,loopo_

	or	a
	jr	nz,loopi_

any_error_1:

	ld	a,(oldwin_)
	out	(0E2h),a

any_error_2:

	ld	c,12h
	ld	a,(handle_)
	rst	10h
	jr	c,any_error_3

any_error_3:

        ld	a,#FF
	out	(89h),a
	ret

acopy_160_:
	push	af
	ld	a,160
	call	acopy_a_
	pop	af
        ret

acopy_a_:
	ld	(acopyn+1),a
	di	
	ld	d,d
acopyn:	ld	a,0
	ld	b,b
	ld	l,l
	ld	a,(hl)
	ld	(de),a
	ld	b,b
	ei
        ret

